function stataPath = findStataExecutable()
    % Define potential root directories to search for Stata
    rootDirs = {'C:\Program Files', 'C:\Program Files (x86)'};

    % Define the executable name
    stataExecutableName = {'StataSE-64.exe','StataMP-64.exe'};

    % Initialize the output variable
    stataPath = '';

    % Search for the executable in each root directory
    for i = 1:length(rootDirs)
        rootDir = rootDirs{i};
        stataPath = searchForExecutable(rootDir, stataExecutableName);
        if ~isempty(stataPath)
            break; % Stop searching once the executable is found
        end
    end

    % Display the result
    if isempty(stataPath)
        disp('Stata executable not found. Please run stata file manually.');
    else
        disp(['Stata executable used for calculation: ', stataPath]);
    end
end

function fullPath = searchForExecutable(rootDir, executableName)

% Recursively search for the executable in the given directory
fullPath = '';

for i = 1:length(executableName)
    files = dir(fullfile(rootDir, '**', executableName{i}));
    if ~isempty(files)
        fullPath = fullfile(files(1).folder, files(1).name);
        break
    end

end
end
